#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009 Yukikaze
import rec10d
#CS放送では複数のチャンネルを指定する必要があるためチャンネル名をテキストデータで持っておき(chtxt)、必要に応じて変換する
#ontvはepgデータなどで指定されている名前
#ここの設定は愛知県の設定(+CS放送スカパーe2 +BS)

def chadd(bctype, ontv, chtxt, ch, csch):#すべて文字列
    """
    ChannelDBに指定したデータを追加する
    bctype:放送種別,bs/cs/te10などが入る。
    番組表データがbs,csは一括でとれるためbs,cs内で区別はなし
    te(地上波)は各チャンネルごとに設定する必要があるためteに
    チャンネルの数字を足したものにする
    """
    rec10d.rec10db.add_epg_ch(bctype, ontv, chtxt, ch, csch, u"2009-04-01 00:00:00")

def new_chdata():
    rec10d.rec10db.new_epg_ch()
    #チャンネルの設定
    #chadd(u'放送種別',u'ontvコード(ontvのサイトなどで調べられる)',u'略称(何でもよい)',u'チャンネル(物理チャンネル)',u'CS放送の場合の内訳')

    #地上波の設定　東京都(筆者は東京で受信していないため正しいかどうか分かりません)
    #chadd(u'te27', u'0031.ontvjapan.com', u'nhk-s',   u'27', u'0')
    #chadd(u'te26', u'0041.ontvjapan.com', u'nhk-k',   u'26', u'0')
    #chadd(u'te25', u'0004.ontvjapan.com', u'nittere', u'25', u'0')
    #chadd(u'te22', u'0005.ontvjapan.com', u'tbs',     u'22', u'0')
    #chadd(u'te21', u'0006.ontvjapan.com', u'fuji',    u'21', u'0')
    #chadd(u'te24', u'0007.ontvjapan.com', u'asahi',   u'24', u'0')
    #chadd(u'te23', u'0008.ontvjapan.com', u'tokyo',   u'23', u'0')
    #chadd(u'te', u'0009.ontvjapan.com', u'tvk',     u'', u'0')
    #chadd(u'te', u'0010.ontvjapan.com', u'chiba',   u'', u'0')
    #chadd(u'te', u'0011.ontvjapan.com', u'gunma',   u'', u'0')
    #chadd(u'te', u'0012.ontvjapan.com', u'tama',    u'', u'0')
    #chadd(u'te28', u'0013.ontvjapan.com', u'housou',  u'28', u'0')
    #chadd(u'te20', u'0016.ontvjapan.com', u'mxtv',    u'20', u'0')
    #chadd(u'te', u'0018.ontvjapan.com', u'tochigi', u'', u'0')
    #地上波の設定　愛知県向け
    chadd(u'te13', u'0442.ontvjapan.com', u'nhk-k', u'13', u'0')
    chadd(u'te20', u'0432.ontvjapan.com', u'nhk-s', u'20', u'0')
    chadd(u'te22', u'0404.ontvjapan.com', u'me-tere', u'22', u'0')
    chadd(u'te18', u'0405.ontvjapan.com', u'cbc', u'18', u'0')
    chadd(u'te21', u'0406.ontvjapan.com', u'toukai', u'21', u'0')
    chadd(u'te19', u'0407.ontvjapan.com', u'chukyo', u'19', u'0')
    chadd(u'te23', u'0420.ontvjapan.com', u'aichi', u'23', u'0')
    chadd(u'te27', u'0417.ontvjapan.com', u'mie', u'27', u'0')



    #CS放送(スカパーe2)主に基本パックには言ってるものを中心に
    chadd(u'cs1', u'1204.ontvjapan.com', u'natiogeo', u'CS6', u'343')
    chadd(u'cs1', u'1070.ontvjapan.com', u'bbc', u'CS12', u'353')
    chadd(u'cs1', u'1069.ontvjapan.com', u'cnn', u'CS12', u'354')
    chadd(u'cs1', u'1045.ontvjapan.com', u'kids', u'CS22', u'330')
    chadd(u'cs1', u'1007.ontvjapan.com', u'movieplus', u'CS18', u'240')
    chadd(u'cs1', u'1016.ontvjapan.com', u'fox', u'CS4', u'312')
    chadd(u'cs1', u'1014.ontvjapan.com', u'axn', u'CS6', u'311')
    chadd(u'cs1', u'1201.ontvjapan.com', u'atx', u'CS16', u'333')
    chadd(u'cs1', u'1050.ontvjapan.com', u'hisch', u'CS16', u'342')
    chadd(u'cs1', u'1047.ontvjapan.com', u'animax', u'CS20', u'332')
    chadd(u'cs1', u'1062.ontvjapan.com', u'disch', u'CS20', u'340')
    chadd(u'cs1', u'1193.ontvjapan.com', u'anipla', u'CS20', u'341')
    chadd(u'cs1', u'1008.ontvjapan.com', u'neco', u'CS6', u'223')
    chadd(u'cs1', u'1015.ontvjapan.com', u'family', u'CS22', u'293')
    chadd(u'cs1', u'1213.ontvjapan.com', u'disney', u'CS4', u'334')
    chadd(u'cs1', u'1092.ontvjapan.com', u'teroasa', u'CS12', u'303')
    chadd(u'cs1', u'1073.ontvjapan.com', u'fuji-one', u'CS20', u'307')
    chadd(u'cs1', u'1072.ontvjapan.com', u'fuji-two', u'CS20', u'308')
    chadd(u'cs1', u'1009.ontvjapan.com', u'yo-ga', u'CS6', u'224')
    chadd(u'cs2', u'1217.ontvjapan.com', u'thecinema', u'CS10', u'228')
    chadd(u'cs2', u'1086.ontvjapan.com', u'nihoneiga', u'CS2', u'239')

    #bs放送の設定　全国共通のはず
    chadd('bs', u'3001.ontvjapan.com', u'bs-nhk-1', u'101', u'0')
    chadd('bs', u'3002.ontvjapan.com', u'bs-nhk-2', u'102', u'0')
    chadd('bs', u'3003.ontvjapan.com', u'bs-nhk-hi', u'103', u'0')
    chadd('bs', u'3004.ontvjapan.com', u'bs-nittere', u'141', u'0')
    chadd('bs', u'3005.ontvjapan.com', u'bs-asahi', u'151', u'0')
    chadd('bs', u'3006.ontvjapan.com', u'bs-tbs', u'161', u'0')
    chadd('bs', u'3007.ontvjapan.com', u'bs-japan', u'171', u'0')
    chadd('bs', u'3008.ontvjapan.com', u'bs-fuji', u'181', u'0')
    chadd('bs', u'3013.ontvjapan.com', u'bs-11', u'211', u'0')
if __name__ == "__main__":
    new_chdata()